#include "Son.h"

using namespace std;
#include <stdlib.h>

#define NBSon 15

//Liste des fichiers son
char *sonList[NBSon]=
{
    ".\\Media\\Son\\Laser\\ak74-fire.wav",
    ".\\Media\\Son\\Laser\\shoot05.wav",
    ".\\Media\\Son\\Laser\\trprsht2.wav",
    ".\\Media\\Son\\Laser\\xlaser.wav",
    ".\\Media\\Son\\Missile\\AI_FIRE3.WAV",
    ".\\Media\\Son\\Missile\\missile.WAV",
    ".\\Media\\Son\\Missile\\rocket1.wav",
    ".\\Media\\Son\\Explosion\\kaboom.wav",
    ".\\Media\\Son\\Explosion\\Ennemis\\explode.wav",
    ".\\Media\\Son\\Explosion\\Ennemis\\explosion2.wav",
    ".\\Media\\Son\\Explosion\\Ennemis\\mine.wav",
    ".\\Media\\Son\\Explosion\\Missile\\blkfoot4.wav",
    ".\\Media\\Son\\Explosion\\Missile\\expl01.wav",
    ".\\Media\\Son\\Explosion\\Missile\\explosion.wav",
    ".\\Media\\Son\\Hit.wav"
};

CSon::CSon()
{
    pz=0.0;
    zmax=2000.0;
    nbSon=0;
    nbSource=0;
    srcPtr=0;
    tabSrc=NULL;
    tabBuff=NULL;
    volume=0.6;
}

CSon::~CSon()
{
    clear();
}

void CSon::loadSound()
{
    tabBuff=new ALuint[NBSon];
    
    unsigned char i;
    for(i=0;i<NBSon;i++)tabBuff[i] = alutCreateBufferFromFile(sonList[i]);
    
    sonReacteur=alutCreateBufferFromFile(".\\Media\\Son\\Battleship loop.wav");
    alGenSources(1,&sourceReacteur);
    alSourcei(sourceReacteur,AL_LOOPING,AL_TRUE);
    alSourcei(sourceReacteur,AL_BUFFER,sonReacteur);
    alSourcef(sourceReacteur,AL_GAIN,(volume*2.2));
    
    this->nbSon=NBSon;
}

void CSon::initSources(unsigned char nbSource)
{
    if(nbSource==0)return;
    
    tabSrc=new ALuint[nbSource];
    
    unsigned char i;
    for(i=0;i<nbSource;i++)
    {
        alGenSources(1,&(tabSrc[i]));
        alSourcef(tabSrc[i],AL_MIN_GAIN,0.0);
        alSourcef(tabSrc[i],AL_MAX_GAIN,1.0);
    }
    
    this->nbSource=nbSource;
    srcPtr=0;
}

void CSon::playSound(unsigned char id,float z,float vol)
{
    if(id<nbSon)
    {
        z-=pz;
        if(z<0.0)z=-z;
        
        if(z==0.0)z=1.0;
        else
        {
            z/=zmax;
            z=1.0-z;
            if(z<=0.0)return;
        }
        
        ALint Status,src=tabSrc[srcPtr];
        alGetSourcei(src, AL_SOURCE_STATE, &Status);
        
        if(Status == AL_PLAYING)
        {
            unsigned char i;
            for(i=(srcPtr+1);i<nbSource;i++)
            {
                alGetSourcei(tabSrc[i], AL_SOURCE_STATE, &Status);
                if(Status != AL_PLAYING)break;
            }
            if(i>=nbSource)
            {
                for(i=0;i<srcPtr;i++)
                {
                    alGetSourcei(tabSrc[i], AL_SOURCE_STATE, &Status);
                    if(Status != AL_PLAYING)break;
                }
                if(i<srcPtr)
                {
                    src=tabSrc[i];
                    tabSrc[i]=tabSrc[srcPtr];
                    tabSrc[srcPtr]=src;
                }
            }
            else
            {
                src=tabSrc[i];
                tabSrc[i]=tabSrc[srcPtr];
                tabSrc[srcPtr]=src;
            }
        }
        
        alSourcei(src,AL_BUFFER,tabBuff[id]);
        alSourcef(src,AL_GAIN,(z*volume*vol));
        alSourcePlay(src);
        
        srcPtr=(srcPtr+1)%nbSource;
    }
}

void CSon::setParam(float pz,float zmax)
{
    this->pz=pz;
    this->zmax=zmax;
}

void CSon::playReacteurLoop()
{
    alSourcePlay(sourceReacteur);
}

void CSon::pauseReacteurLoop()
{
    alSourcePause(sourceReacteur);
}

void CSon::stopReacteurLoop()
{
    alSourceStop(sourceReacteur);
}


void CSon::setVolume(float volume)
{
    this->volume=volume;
}

#include <stdio.h>

void CSon::clear()
{
    unsigned char i;
    
    if(tabSrc && nbSource)
    {
        for(i=0;i<nbSource;i++)alDeleteSources(1,&(tabSrc[i]));
        delete []tabSrc;
        tabSrc=NULL;
        nbSource=0;
        srcPtr=0;
    }
    
    if(tabBuff && nbSon)
    {
        for(i=0;i<nbSon;i++)alDeleteBuffers(1,&(tabBuff[i]));
        delete []tabBuff;
        tabBuff=NULL;
        nbSon=0;
        
        alDeleteSources(1,&sourceReacteur);
        alDeleteBuffers(1,&sonReacteur);
    }
}
